package me.alexdevs.solstice.api.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.alexdevs.solstice.Solstice;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import java.util.concurrent.CompletableFuture;

public class LocalGameProfile {
    public static GameProfile getGameProfile(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        var profiles = class_2191.method_9330(context, name);
        if (profiles.size() > 1) {
            throw class_2186.field_9864.create();
        }

        return profiles.iterator().next();
    }

    public static GameProfile getProfile(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        var profileName = StringArgumentType.getString(context, name);
        var profile = Solstice.getUserCache().getByName(profileName);
        if(profile.isEmpty())
            throw class_2191.field_9869.create();

        return profile.get();
    }

    /**
     * Suggest player name. Prefer online players, then cached.
     * @param context
     * @param builder
     * @return
     */
    public static CompletableFuture<Suggestions> suggest(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        var server = context.getSource().method_9211();
        var onlinePlayers = server.method_3760().method_14580();

        var input = builder.getRemainingLowerCase();
        for (var player : onlinePlayers) {
            if (class_2172.method_27136(input, player.toLowerCase())) {
                return class_2172.method_9253(onlinePlayers, builder);
            }
        }

        var cachedPlayers = Solstice.getUserCache().getAllNames();
        return class_2172.method_9265(cachedPlayers, builder);
    }
}
