package me.alexdevs.solstice.api.text.parser;

import eu.pb4.placeholders.api.node.DirectTextNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;

public class CodeParser implements NodeParser {
    public static final Pattern CODE_REGEX = Pattern.compile("(?<!\\\\)`(.*?)(?<!\\\\)`");

    @Override
    public TextNode[] parseNodes(TextNode node) {
        if (node instanceof LiteralNode literal) {
            var input = literal.value();
            var list = new ArrayList<TextNode>();
            var inputLength = input.length();

            var matcher = CODE_REGEX.matcher(input);
            int pos = 0;

            while (matcher.find()) {
                if (inputLength <= matcher.start()) {
                    break;
                }

                String betweenText = input.substring(pos, matcher.start());

                if (!betweenText.isEmpty()) {
                    list.add(new LiteralNode(betweenText));
                }

                var content = matcher.group(1);

                var display = class_2561.method_43470(content).method_27692(class_124.field_1080);
                var hover = class_2561.method_30163("Click to copy");

                var text = class_2561.method_43473()
                        .method_10852(display)
                        .method_10862(class_2583.field_24360
                                .method_10949(
                                        new class_2568(class_2568.class_5247.field_24342, hover)
                                )
                                .method_10958(new class_2558(class_2558.class_2559.field_21462, content))
                        );

                list.add(new DirectTextNode(text));

                pos = matcher.end();
            }

            if (pos < inputLength) {
                var text = input.substring(pos, inputLength);
                if (!text.isEmpty()) {
                    list.add(new LiteralNode(text));
                }
            }

            return list.toArray(TextNode[]::new);
        }
        return TextNode.array(node);
    }
}
