package me.alexdevs.solstice.core.coreModule.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServerStatCommand extends ModCommand<CoreModule> {
    public ServerStatCommand(CoreModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("serverstat", "tps");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("serverstat", 3))
                .executes(context -> {
                    var locale = module.locale();
                    var placeholderContext = PlaceholderContext.of(context.getSource());

                    var messages = new ArrayList<class_2561>();

                    messages.add(locale.get("stat.tps", placeholderContext));

                    var uptime = Duration.ofMillis(ManagementFactory.getRuntimeMXBean().getUptime());
                    var uptimeFormatted = TimeSpan.toShortString((int)uptime.getSeconds());
                    messages.add(locale.get("stat.uptime", placeholderContext, Map.of(
                            "uptime", class_2561.method_30163(uptimeFormatted)
                    )));

                    var maxMemory = Runtime.getRuntime().maxMemory() / 1024 / 1024;
                    var allocatedMemory = Runtime.getRuntime().totalMemory() / 1024 / 1024;
                    var freeMemory = Runtime.getRuntime().freeMemory() / 1024 / 1024;

                    messages.add(locale.get("stat.maxMemory", placeholderContext, Map.of(
                            "memory", class_2561.method_30163(String.valueOf(maxMemory)),
                            "hover", locale.get("stat.maxMemory.hover")
                    )));

                    messages.add(locale.get("stat.dedicatedMemory", placeholderContext, Map.of(
                            "memory", class_2561.method_30163(String.valueOf(allocatedMemory)),
                            "hover", locale.get("stat.dedicatedMemory.hover")

                    )));

                    messages.add(locale.get("stat.freeMemory", placeholderContext, Map.of(
                            "memory", class_2561.method_30163(String.valueOf(freeMemory)),
                            "hover", locale.get("stat.freeMemory.hover")
                    )));

                    var text = class_2561.method_43473();
                    text.method_10852(locale.get("stat.title"));

                    for(var message : messages) {
                        text.method_10852(class_2561.method_30163("\n"));
                        text.method_10852(message);
                    }

                    context.getSource().method_9226(() -> text, false);

                    return 1;
                });
    }
}
