package me.alexdevs.solstice.locale;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.text.Format;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.Map;
import java.util.function.Supplier;

public class Locale {
    public final class_2960 id;

    private final Supplier<Map<String, String>> localeSupplier;

    public Locale(class_2960 id, Supplier<Map<String, String>> localeSupplier) {
        this.id = id;
        this.localeSupplier = localeSupplier;
    }

    public String raw(String path) {
        String fullPath;
        if (path.startsWith("~")) {
            fullPath = "shared." + path.substring(1);
        } else if (path.startsWith("/")) {
            fullPath = path.substring(1);
        } else {
            var id = this.id.toString().replace(':', '.');
            fullPath = "module." + id + "." + path;
        }

        return localeSupplier.get().get(fullPath);
    }

    public class_2561 get(String path) {
        var src = this.raw(path);
        return Format.parse(src);
    }

    public class_2561 get(String path, PlaceholderContext context) {
        var src = this.raw(path);
        return Format.parse(src, context);
    }

    public class_2561 get(String path, Map<String, class_2561> placeholders) {
        var src = this.raw(path);
        return Format.parse(src, placeholders);
    }

    public class_2561 get(String path, PlaceholderContext context, Map<String, class_2561> placeholders) {
        var src = this.raw(path);
        return Format.parse(src, context, placeholders);
    }
}
