package me.alexdevs.solstice.mixin.modules.spawn;

import me.alexdevs.solstice.modules.ModuleProvider;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3222.class)
public abstract class OverrideSpawnPointLevelMixin {

    @Shadow
    private class_2338 respawnPosition;

    @Inject(method = "getRespawnPosition", at = @At("RETURN"), cancellable = true)
    public void solstice$overrideSpawnPos(CallbackInfoReturnable<class_2338> cir) {
        var spawnModule = ModuleProvider.SPAWN;
        var config = spawnModule.getConfig();

        var pos = spawnModule.getGlobalSpawnPosition().getBlockPos();
        if(config.globalSpawn.onRespawnSoft && this.respawnPosition == null) {
            cir.setReturnValue(pos);
        }

        if (config.globalSpawn.onRespawn) {
            cir.setReturnValue(pos);
        }
    }

    @Inject(method = "getRespawnDimension", at = @At("RETURN"), cancellable = true)
    public void solstice$overrideSpawnDimension(CallbackInfoReturnable<class_5321<class_1937>> cir) {
        var spawnModule = ModuleProvider.SPAWN;
        var config = spawnModule.getConfig();
        var levelKey = spawnModule.getGlobalSpawnPosition().getWorldKey();
        if(config.globalSpawn.onRespawnSoft && this.respawnPosition == null) {
            cir.setReturnValue(levelKey);
        }

        if (config.globalSpawn.onRespawn) {
            cir.setReturnValue(levelKey);
        }
    }
}
