package me.alexdevs.solstice.mixin.modules.spawn;

import me.alexdevs.solstice.modules.ModuleProvider;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;

@Mixin(class_1657.class)
public abstract class OverrideSpawnPointMixin {
    @Inject(method = "findRespawnPositionAndUseSpawnBlock", at = @At("RETURN"), cancellable = true)
    private static void solstice$overrideSpawnPos(class_3218 level, class_2338 pos, float angle, boolean forced, boolean alive, CallbackInfoReturnable<Optional<class_243>> cir) {
        var spawnModule = ModuleProvider.SPAWN;
        var config = spawnModule.getConfig();

        var spawn = spawnModule.getGlobalSpawnPosition();
        if (config.globalSpawn.onRespawnSoft && pos == null) {
            pos = spawn.getBlockPos();
            cir.setReturnValue(Optional.of(pos.method_46558()));
        }

        if (config.globalSpawn.onRespawn) {
            pos = spawn.getBlockPos();
            cir.setReturnValue(Optional.of(pos.method_46558()));
        }
    }
}
