package me.alexdevs.solstice.mixin.modules.styling;

import me.alexdevs.solstice.modules.styling.formatters.AdvancementFormatter;
import net.minecraft.class_161;
import net.minecraft.class_2561;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_2985.class)
public abstract class CustomAdvancementMixin {
    @Shadow
    private class_3222 player;
    @Final
    @Shadow
    private class_3324 playerList;

    @Inject(method = "award", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/players/PlayerList;broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Z)V"), locals = LocalCapture.CAPTURE_FAILSOFT)
    public void broadcastAdvancementMessage(class_161 advancement, String criterionKey, CallbackInfoReturnable<Boolean> cir) {
        this.playerList.method_43514(AdvancementFormatter.getText(this.player, advancement), false);
    }

    @Redirect(method = "award", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/players/PlayerList;broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Z)V"))
    public void broadcastSystemMessageRedirect(class_3324 instance, class_2561 message, boolean bypassHiddenChat) { // Redirect this method into nothing.
    }
}
