package me.alexdevs.solstice.mixin.modules.styling;

import me.alexdevs.solstice.modules.styling.StylingModule;
import me.alexdevs.solstice.modules.styling.formatters.ConnectionActivityFormatter;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3324.class)
public abstract class CustomConnectionMessagesMixin {
    @Unique
    private class_3222 solstice$player = null;

    @Inject(method = "placeNewPlayer", at = @At("HEAD"))
    private void solstice$onJoin(class_2535 connection, class_3222 player, CallbackInfo ci) {
        solstice$player = player;
    }

    @Inject(method = "placeNewPlayer", at = @At("RETURN"))
    private void solstice$onJoinReturn(class_2535 connection, class_3222 player, CallbackInfo ci) {
        solstice$player = null;
    }

    @Redirect(method = "placeNewPlayer", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/players/PlayerList;broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Z)V"))
    private void solstice$sendJoinMessage(class_3324 list, class_2561 message, boolean bypassHiddenChat) {
        var ogText = (class_2588) message.method_10851();
        var args = ogText.method_11023();

        class_2561 formattedMessage;
        if (args.length == 1) {
            formattedMessage = ConnectionActivityFormatter.onJoin(solstice$player);
        } else {
            formattedMessage = ConnectionActivityFormatter.onJoinRenamed(solstice$player, (String) args[1]);
        }

        StylingModule.broadcastActivity(list, formattedMessage, bypassHiddenChat);
    }
}
