package me.alexdevs.solstice.modules.afk.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.afk.AfkModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

public class ActiveTimeCommand extends ModCommand<AfkModule> {
    public ActiveTimeCommand(AfkModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("activetime");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require(true))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var activeTime = module.getActiveTime(player.method_5667());

                    var longSpan = TimeSpan.toLongString(activeTime);

                    var map = Map.of(
                            "activeTime", class_2561.method_30163(longSpan),
                            "player", player.method_5477()
                    );

                    context.getSource().method_9226(() -> module.locale().get("yourActiveTime", map), false);

                    return 1;
                })
                .then(class_2170.method_9247("player")
                        .requires(require("others", 1))
                        .then(class_2170.method_9244("player", StringArgumentType.word())
                                .suggests(LocalGameProfile::suggest)
                                .executes(context -> {
                                    var profile = LocalGameProfile.getProfile(context, "player");
                                    var activeTime = module.getActiveTime(profile.getId());

                                    if (activeTime == 0) {
                                        context.getSource().method_9226(() -> module.locale().get("neverPlayed"), false);
                                        return 0;
                                    }

                                    var longSpan = TimeSpan.toLongString(activeTime);

                                    var map = Map.of(
                                            "activeTime", class_2561.method_30163(longSpan),
                                            "player", class_2561.method_30163(profile.getName())
                                    );

                                    context.getSource().method_9226(() -> module.locale().get("playerActiveTime", map), false);

                                    return 1;
                                })
                        ))
                .then(class_2170.method_9247("leaderboard")
                        .requires(require("leaderboard", true))
                        .executes(context -> {
                            var leaderboard = module.getActiveTimeLeaderboard();

                            var text = class_2561.method_43473();

                            text.method_10852(module.locale().get("leaderboardHeader"));

                            var index = 0;
                            for (var entry : leaderboard) {
                                text.method_27693("\n");
                                index++;
                                var map = Map.of(
                                        "index", class_2561.method_30163(String.valueOf(index)),
                                        "player", class_2561.method_30163(entry.name()),
                                        "uuid", class_2561.method_30163(entry.uuid().toString()),
                                        "time", class_2561.method_30163(TimeSpan.toLongString(entry.activeTime())),
                                        "shortTime", class_2561.method_30163(TimeSpan.toShortString(entry.activeTime())),
                                        "seconds", class_2561.method_30163(String.valueOf(entry.activeTime()))
                                );
                                text.method_10852(module.locale().get("leaderboardEntry", map));
                            }

                            context.getSource().method_9226(() -> text, false);

                            return 1;
                        })
                )
                .then(class_2170.method_9247("set")
                        .requires(require("set", 3))
                        .then(class_2170.method_9244("player", StringArgumentType.word())
                                .suggests(LocalGameProfile::suggest)
                                .then(class_2170.method_9244("time", TimeSpan.timeSpan())
                                        .suggests(TimeSpan::suggest)
                                        .executes(context -> {
                                            var profile = LocalGameProfile.getProfile(context, "player");
                                            var time = TimeSpan.getTimeSpan(context, "time");

                                            var data = module.getPlayerData(profile.getId());
                                            data.activeTime = time;

                                            var map = Map.of(
                                                    "player", class_2561.method_30163(profile.getName()),
                                                    "time", class_2561.method_30163(TimeSpan.toLongString(time))
                                            );
                                            context.getSource().method_9226(() -> module.locale().get("activeTimeSet", map), true);

                                            return 1;
                                        })
                                ))
                )
                .then(class_2170.method_9247("recalculate")
                        .requires(require("recalculate", 2))
                        .executes(context -> {
                            module.forceRecalculateLeaderboard();

                            context.getSource().method_9226(() -> module.locale().get("leaderboardRecalculated"), true);

                            return 1;
                        }));
    }
}
