package me.alexdevs.solstice.modules.cooldown.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.cooldown.CooldownModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class CooldownCommand extends ModCommand<CooldownModule> {
    public CooldownCommand(CooldownModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("cooldown");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require(1))
                .then(class_2170.method_9247("clear")
                        .requires(require("clear", 3))
                        .then(class_2170.method_9244("player", class_2186.method_9305())
                                .then(class_2170.method_9244("key", StringArgumentType.word())
                                        .suggests(this::suggestKeys)
                                        .executes(this::clearCooldown)
                                )

                        )
                )
                .then(class_2170.method_9247("check")
                        .requires(require("check", 1))
                        .then(class_2170.method_9244("player", class_2186.method_9305())
                                .then(class_2170.method_9244("key", StringArgumentType.word())
                                        .suggests(this::suggestKeys)
                                        .executes(this::checkCooldown)
                                )
                        )
                );
    }

    private CompletableFuture<Suggestions> suggestKeys(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(module.getKeys(), builder);
    }

    private int clearCooldown(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = class_2186.method_9315(context, "player");
        var key = StringArgumentType.getString(context, "key");

        if(module.isExempt(player, key)) {
            var placeholders = Map.of(
                    "player", player.method_5477(),
                    "key", class_2561.method_43470(key)
            );

            context.getSource().method_9213(module.locale().get("exempt", placeholders));

            return 0;
        }

        var value = module.getCooldown(player, key);
        if(value.isEmpty()) {
            var placeholders = Map.of(
                    "player", player.method_5477(),
                    "key", class_2561.method_43470(key)
            );

            context.getSource().method_9213(module.locale().get("noCooldown", placeholders));

            return 0;
        }

        module.clear(player, key);

        var placeholders = Map.of(
                "player", player.method_5477(),
                "key", class_2561.method_43470(key)
        );

        context.getSource().method_9226(() -> module.locale().get("cleared", placeholders), true);

        return 1;
    }

    private int checkCooldown(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = class_2186.method_9315(context, "player");
        var key = StringArgumentType.getString(context, "key");

        if(module.isExempt(player, key)) {
            var placeholders = Map.of(
                    "player", player.method_5477(),
                    "key", class_2561.method_43470(key)
            );

            context.getSource().method_9213(module.locale().get("exempt", placeholders));

            return 0;
        }

        var value = module.getCooldown(player, key);
        if(value.isEmpty()) {
            var placeholders = Map.of(
                    "player", player.method_5477(),
                    "key", class_2561.method_43470(key)
            );

            context.getSource().method_9213(module.locale().get("noCooldown", placeholders));

            return 0;
        }

        var span = TimeSpan.toShortString(value.get());

        var placeholders = Map.of(
                "player", player.method_5477(),
                "key", class_2561.method_43470(key),
                "timespan", class_2561.method_30163(span)
        );

        context.getSource().method_9226(() -> module.locale().get("checkResult", placeholders), false);

        return 1;
    }
}
