package me.alexdevs.solstice.modules.enderchest.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.utils.PlayerUtils;
import me.alexdevs.solstice.modules.enderchest.EnderChestModule;
import me.alexdevs.solstice.modules.inventorySee.ImmutableSlot;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1730;
import net.minecraft.class_1735;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3917;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class EnderChestCommand extends ModCommand<EnderChestModule> {
    public EnderChestCommand(EnderChestModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("enderchest", "ec");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    player.method_7281(class_3468.field_15424);

                    open(player, player.method_7274(), class_2561.method_43471("container.enderchest"), true, () -> {
                    });

                    return 1;
                })
                .then(method_9244("player", StringArgumentType.word())
                        .requires(require("others", 2))
                        .suggests(LocalGameProfile::suggest)
                        .executes(context -> {
                            final var source = context.getSource();
                            var player = source.method_9207();
                            var profile = LocalGameProfile.getProfile(context, "player");

                            Permissions.check(profile, getPermissionNode("exempt"), 3, source.method_9211()).thenAccept(exempt -> {
                                if (exempt) {
                                    source.method_9226(() -> module.locale().get("exempt"), false);
                                    return;
                                }

                                var isOnline = PlayerUtils.isOnline(profile.getId());
                                if (!isOnline && !Permissions.check(player, getPermissionNode("offline"), 3)) {
                                    source.method_9226(() -> module.locale().get("offlineNotAllowed"), false);
                                    return;
                                }

                                class_3222 targetPlayer;

                                if (isOnline) {
                                    targetPlayer = source.method_9211().method_3760().method_14602(profile.getId());
                                } else {
                                    targetPlayer = PlayerUtils.loadOfflinePlayer(profile);
                                }

                                var inventory = targetPlayer.method_7274();

                                var canEdit = Permissions.check(player, getPermissionNode("edit"), 3);

                                var map = Map.of(
                                        "player", class_2561.method_30163(profile.getName())
                                );
                                var title = module.locale().get("title", map);

                                open(player, inventory, title, canEdit, () -> {
                                    if(!isOnline) {
                                        PlayerUtils.saveOfflinePlayer(targetPlayer);
                                    }
                                });

                                source.method_9226(() -> module.locale().get("opened", map), true);
                            });

                            return 1;
                        }));
    }

    private void open(class_3222 player, class_1730 inventory, class_2561 title, boolean canEdit, Runnable onClose) {
        var container = new SimpleGui(class_3917.field_17326, player, false) {
            @Override
            public void onClose() {
                onClose.run();
            }
        };

        for (var i = 0; i < inventory.method_5439(); i++) {
            class_1735 slot;
            if (canEdit) {
                slot = new class_1735(inventory, i, 0, 0);
            } else {
                slot = new ImmutableSlot(inventory, i, 0, 0);
            }
            container.setSlotRedirect(i, slot);
        }

        container.setTitle(title);

        container.open();
    }
}
