package me.alexdevs.solstice.modules.experiments.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.experiments.ExperimentsModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2561;
import java.util.List;

public class SafeTeleportCommand extends ModCommand<ExperimentsModule> {
    public SafeTeleportCommand(ExperimentsModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("safetp");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .then(class_2170.method_9244("position", class_2262.method_9698())
                        .executes(context ->  {
                            var pos = class_2262.method_48299(context, "position");
                            var player = context.getSource().method_9207();

                            var loc = new ServerLocation(pos.method_10263(), pos.method_10264(), pos.method_10260(), 0, 0, context.getSource().method_9225());

                            var success = loc.safeTeleport(player);
                            if (!success) {
                                context.getSource().method_9213(class_2561.method_43470("Could not find a safe position nearby!"));
                                return 0;
                            }

                            context.getSource().method_9226(() -> class_2561.method_43470("Successfully teleported to a safe position!"), false);
                            return 1;
                        })
                );
    }


}
