package me.alexdevs.solstice.modules.extinguish.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.extinguish.ExtinguishModule;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class ExtinguishCommand extends ModCommand<ExtinguishModule> {
    public ExtinguishCommand(ExtinguishModule module) {
        super(module);
    }

    private static int execute(CommandContext<class_2168> context, @Nullable Collection<class_3222> players) throws CommandSyntaxException {
        var source = context.getSource();
        if (players == null) {
            extinguish(source, source.method_9207());
            return 1;
        } else {
            for (class_3222 player : players) {
                extinguish(source, player);
            }

            return players.size();
        }
    }

    private static void extinguish(class_2168 source, class_3222 player) {
        player.method_5646();
        source.method_9226(() -> class_2561.method_43470("Extinguished ").method_10852(source.method_9223()), true);
    }

    @Override
    public List<String> getNames() {
        return List.of("extinguish", "ex");
    }

    public LiteralArgumentBuilder<class_2168> command(String command) {
        return method_9247(command)
                .requires(require(2))
                .executes(context -> execute(context, null))
                .then(method_9244("players", class_2186.method_9308())
                        .executes(context -> execute(context, class_2186.method_9312(context, "players"))));
    }
}
