package me.alexdevs.solstice.modules.hat.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.hat.HatModule;
import net.minecraft.class_2168;
import java.util.List;

import static net.minecraft.class_2170.method_9247;

public class HatCommand extends ModCommand<HatModule> {
    public HatCommand(HatModule module) {
        super(module);
    }


    @Override
    public List<String> getNames() {
        return List.of("hat");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var handStack = player.method_6047();

                    if (handStack.method_7960()) {
                        context.getSource().method_9226(() -> module.locale().get("emptyStack"), false);
                        return 0;
                    }

                    var config = module.getConfig();

                    var itemId = handStack.method_41409().method_40230().get().method_29177().toString();
                    var tags = handStack.method_40133();
                    if (config.whitelistFilter) {
                        if(!module.isInFilter(itemId) && !module.isInFilter(tags)) {
                            context.getSource().method_9226(() -> module.locale().get("notAllowed"), false);
                            return 0;
                        }
                    } else {
                        if(module.isInFilter(itemId) || module.isInFilter(tags)) {
                            context.getSource().method_9226(() -> module.locale().get("notAllowed"), false);
                            return 0;
                        }
                    }

                    //handStack.streamTags().toList().get(0).id().toString();

                    var inventory = player.method_31548();
                    var oldHeadStack = inventory.field_7548.get(3); // head slot
                    inventory.method_5447(inventory.field_7545, oldHeadStack.method_51164());
                    inventory.field_7548.set(3, handStack.method_51164());

                    context.getSource().method_9226(() -> module.locale().get("success"), false);

                    return 1;
                });
    }
}
