package me.alexdevs.solstice.modules.heal.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.heal.HealModule;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class HealCommand extends ModCommand<HealModule> {
    public HealCommand(HealModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("heal");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .executes(context -> execute(context, null))
                .then(method_9244("targets", class_2186.method_9306())
                        .requires(require("others", 2))
                        .executes(context -> execute(context, class_2186.method_9317(context, "targets"))));
    }

    private int execute(CommandContext<class_2168> context, @Nullable Collection<? extends class_1297> targets) throws CommandSyntaxException {
        if (targets == null) {
            var player = context.getSource().method_9207();
            heal(context, player, 1);
            return 1;
        } else {
            var healedCount = 0;
            for (var target : targets) {
                if (target instanceof class_1309 livingEntity) {
                    healedCount++;
                    heal(context, livingEntity, targets.size());
                }
            }

            if (healedCount == 0) {
                context.getSource().method_9213(module.locale().get("noLiving"));
            } else if (healedCount > 1) {
                var placeholders = Map.of(
                        "count", class_2561.method_30163(String.valueOf(healedCount))
                );

                context.getSource().method_9226(() -> module.locale().get("healedMultiple", placeholders), true);
            }
            return healedCount;
        }
    }

    private void heal(CommandContext<class_2168> context, class_1309 entity, int count) {
        entity.method_6033(entity.method_6063());

        if( count == 1) {
            var placeholders = Map.of(
                    "entity", entity.method_5477()
            );

            context.getSource().method_9226(() -> module.locale().get("healed", placeholders), true);
        }
    }
}
