package me.alexdevs.solstice.modules.helpOp.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.helpOp.HelpOpModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class HelpOpCommand extends ModCommand<HelpOpModule> {
    public HelpOpCommand(HelpOpModule module) {
        super(module);
    }


    @Override
    public List<String> getNames() {
        return List.of("helpop", "sos");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .then(method_9244("message", StringArgumentType.greedyString())
                        .executes(context -> {
                            var source = context.getSource();
                            var sourceContext = PlaceholderContext.of(source);
                            var message = StringArgumentType.getString(context, "message");

                            var placeholders = Map.of(
                                    "message", class_2561.method_30163(message)
                            );
                            var requestMessage = module.locale().get(
                                    "helpRequestMessage",
                                    sourceContext,
                                    placeholders

                            );
                            source.method_9211().method_43496(requestMessage);

                            source.method_9211().method_3760().method_14571().forEach(player -> {
                                if (Permissions.check(player, getPermissionNode("operator"), 1)) {
                                    player.method_43496(requestMessage);
                                }
                            });

                            source.method_9226(() -> module.locale().get("helpRequestFeedback", sourceContext, placeholders), false);

                            return 1;
                        }));
    }
}
