package me.alexdevs.solstice.modules.home.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.home.HomeModule;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class HomeOtherCommand extends ModCommand<HomeModule> {
    public HomeOtherCommand(HomeModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("homeother");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("others", 2))
                .then(method_9244("player", StringArgumentType.word())
                        .suggests(LocalGameProfile::suggest)
                        .executes(context -> execute(context, "home"))
                        .then(method_9244("name", StringArgumentType.word())
                                .executes(context -> execute(context, StringArgumentType.getString(context, "name")))));
    }

    private int execute(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        var sourcePlayer = context.getSource().method_9207();
        var profile = LocalGameProfile.getProfile(context, "player");
        var playerContext = PlaceholderContext.of(context.getSource().method_44023());


        var data = module.getData(profile.getId());

        var placeholders = Map.of(
                "home", class_2561.method_30163(name),
                "owner", class_2561.method_30163(profile.getName())
        );

        if (!data.homes.containsKey(name)) {
            context.getSource().method_9226(() ->
                    module.locale().get(
                            "homeNotFound",
                            playerContext,
                            placeholders
                    ), false);

            return 1;
        }

        context.getSource().method_9226(() ->
                module.locale().get(
                        "teleportingOther",
                        playerContext,
                        placeholders
                ), true);

        var homePosition = data.homes.get(name);
        homePosition.teleport(sourcePlayer);

        return 1;
    }
}
