package me.alexdevs.solstice.modules.ignite.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.ignite.IgniteModule;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class IgniteCommand extends ModCommand<IgniteModule> {
    public static final int defaultTicks = 200; // 10 seconds

    public IgniteCommand(IgniteModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("ignite");
    }

    public LiteralArgumentBuilder<class_2168> command(String command) {
        return method_9247(command)
                .requires(require(2))
                .executes(context -> execute(context, null, null))
                .then(method_9244("players", class_2186.method_9308())
                        .executes(context -> execute(context, class_2186.method_9312(context, "players"), null))
                        .then(method_9244("ticks", IntegerArgumentType.integer(0))
                                .executes(context ->
                                        execute(context, class_2186.method_9312(context, "players"), IntegerArgumentType.getInteger(context, "ticks"))
                                )
                        )
                );
    }

    private int execute(CommandContext<class_2168> context, @Nullable Collection<class_3222> players, @Nullable Integer ticks) throws CommandSyntaxException {
        var source = context.getSource();
        if (players == null) {
            ignite(source, source.method_9207(), ticks);
            return 1;
        } else {
            for (class_3222 player : players) {
                ignite(source, player, ticks);
            }

            return players.size();
        }
    }

    private void ignite(class_2168 source, class_3222 player, @Nullable Integer ticks) {
        if (ticks == null) {
            player.method_20803(defaultTicks);
            source.method_9226(() -> class_2561.method_43470("Ignited ").method_10852(source.method_9223()), true);
        } else {
            player.method_20803(ticks);
            source.method_9226(() -> class_2561.method_43470("Ignited ").method_10852(source.method_9223()).method_10852(class_2561.method_30163(String.format(" for %d ticks", ticks))), true);
        }
    }
}
