package me.alexdevs.solstice.modules.ignore;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.ignore.commands.IgnoreCommand;
import me.alexdevs.solstice.modules.ignore.commands.IgnoreListCommand;
import me.alexdevs.solstice.modules.ignore.data.IgnoreLocale;
import me.alexdevs.solstice.modules.ignore.data.IgnorePlayerData;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import java.util.UUID;
public class IgnoreModule extends ModuleBase.Toggleable {


    public IgnoreModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerLocale(IgnoreLocale.MODULE);
        registerPlayerData(IgnorePlayerData.class, IgnorePlayerData::new);

        commands.add(new IgnoreCommand(this));
        commands.add(new IgnoreListCommand(this));
    }

    public IgnorePlayerData getPlayerData(UUID playerUuid) {
        return Solstice.playerData.get(playerUuid).getData(IgnorePlayerData.class);
    }

    public boolean isIgnoring(class_3222 player, class_3222 target) {
        if(!isEnabled())
            return false;

        return getPlayerData(player.method_5667()).ignoredPlayers.contains(target.method_5667()) && !Permissions.check(target, this.getPermissionNode("exempt"), 2);
    }
}
