package me.alexdevs.solstice.modules.inventorySee.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.emi.trinkets.api.TrinketsApi;
import eu.pb4.sgui.api.gui.SimpleGui;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.utils.PlayerUtils;
import me.alexdevs.solstice.integrations.TrinketsIntegration;
import me.alexdevs.solstice.modules.inventorySee.ImmutableSlot;
import me.alexdevs.solstice.modules.inventorySee.InventorySeeModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class InventorySeeCommand extends ModCommand<InventorySeeModule> {
    public InventorySeeCommand(InventorySeeModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("invsee", "inventorysee");
    }

    private static final LinkedHashMap<Integer, class_3917<class_1707>> invSizes = new LinkedHashMap<>();

    static {
        invSizes.put(9, class_3917.field_18664);
        invSizes.put(18, class_3917.field_18665);
        invSizes.put(27, class_3917.field_17326);
        invSizes.put(36, class_3917.field_18666);
        invSizes.put(45, class_3917.field_18667);
        invSizes.put(54, class_3917.field_17327);
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9244("player", StringArgumentType.word())
                        .suggests(LocalGameProfile::suggest)
                        .executes(context -> {
                            var source = context.getSource();
                            var player = source.method_9207();
                            var targetProfile = LocalGameProfile.getProfile(context, "player");
                            var targetOnline = PlayerUtils.isOnline(targetProfile.getId());

                            if (!targetOnline && !Permissions.check(player, getPermissionNode("offline"), 3)) {
                                source.method_9226(() -> module.locale().get("offlineNotAllowed"), false);
                                return 0;
                            }

                            class_3222 target;
                            if (targetOnline) {
                                target = context.getSource().method_9211().method_3760().method_14602(targetProfile.getId());
                                if (Permissions.check(target, getPermissionNode("exempt"), 3)) {
                                    source.method_9226(() -> module.locale().get("exempt"), false);
                                    return 0;
                                }
                            } else {
                                target = PlayerUtils.loadOfflinePlayer(targetProfile);
                                if (Permissions.check(targetProfile, getPermissionNode("exempt"), 3, source.method_9211()).getNow(false)) {
                                    source.method_9226(() -> module.locale().get("exempt"), false);
                                    return 0;
                                }
                            }

                            var canEdit = Permissions.check(player, getPermissionNode("edit"), 3);

                            var targetInventory = target.method_31548();

                            var container = new SimpleGui(class_3917.field_18667, player, false) {
                                @Override
                                public void onClose() {
                                    if (!targetOnline) {
                                        PlayerUtils.saveOfflinePlayer(target);
                                    }
                                }
                            };

                            for (var i = 0; i < targetInventory.method_5439(); i++) {
                                class_1735 slot;
                                if (canEdit) {
                                    slot = new class_1735(targetInventory, i, 0, 0);
                                } else {
                                    slot = new ImmutableSlot(targetInventory, i, 0, 0);
                                }
                                container.setSlotRedirect(i, slot);
                            }

                            var barrier = new class_1799(class_1802.field_8157);
                            barrier.method_7977(class_2561.method_43470(""));
                            for (var i = targetInventory.method_5439(); i < container.getSize(); i++) {
                                container.setSlot(i, barrier);
                            }

                            container.setTitle(target.method_5477());

                            container.open();

                            var map = Map.of(
                                    "user", class_2561.method_30163(target.method_7334().getName())
                            );
                            source.method_9226(() -> module.locale().get("openedInventory", map), true);

                            return 1;
                        })
                        .then(method_9247("trinkets")
                                .executes(context -> {
                                    var source = context.getSource();
                                    var player = source.method_9207();
                                    var targetProfile = LocalGameProfile.getProfile(context, "player");
                                    var targetOnline = PlayerUtils.isOnline(targetProfile.getId());

                                    if (!targetOnline && !Permissions.check(player, getPermissionNode("offline"), 3)) {
                                        source.method_9226(() -> module.locale().get("offlineNotAllowed"), false);
                                        return 0;
                                    }

                                    class_3222 target;
                                    if (targetOnline) {
                                        target = context.getSource().method_9211().method_3760().method_14602(targetProfile.getId());
                                        if (Permissions.check(target, getPermissionNode("exempt"), 3)) {
                                            source.method_9226(() -> module.locale().get("exempt"), false);
                                            return 0;
                                        }
                                    } else {
                                        target = PlayerUtils.loadOfflinePlayer(targetProfile);
                                        if (Permissions.check(targetProfile, getPermissionNode("exempt"), 3, source.method_9211()).getNow(false)) {
                                            source.method_9226(() -> module.locale().get("exempt"), false);
                                            return 0;
                                        }
                                    }

                                    if (!TrinketsIntegration.isAvailable()) {
                                        source.method_9226(() -> module.locale().get("trinketsNotInstalled"), false);
                                        return 0;
                                    }

                                    var canEdit = Permissions.check(player, getPermissionNode("edit"), 3);

                                    var trinkets = TrinketsApi.getTrinketComponent(target).orElse(null);
                                    var slots = new ArrayList<class_1735>();
                                    for (var group : trinkets.getInventory().values()) {
                                        for (var inventory : group.values()) {
                                            for (var i = 0; i < inventory.method_5439(); i++) {
                                                class_1735 slot;
                                                if (canEdit) {
                                                    slot = new class_1735(inventory, i, 0, 0);
                                                } else {
                                                    slot = new ImmutableSlot(inventory, i, 0, 0);
                                                }
                                                slots.add(slot);
                                            }
                                        }
                                    }

                                    var size = slots.size();
                                    class_3917<class_1707> handlerType = null;
                                    for (var entry : invSizes.entrySet()) {
                                        handlerType = entry.getValue();
                                        if (size <= entry.getKey()) {
                                            break;
                                        }
                                    }

                                    var container = new SimpleGui(handlerType, player, false) {
                                        @Override
                                        public void onClose() {
                                            if (!targetOnline) {
                                                PlayerUtils.saveOfflinePlayer(target);
                                            }
                                        }
                                    };

                                    for (var i = 0; i < slots.size(); i++) {
                                        var slot = slots.get(i);
                                        container.setSlotRedirect(i, slot);
                                    }

                                    var barrier = new class_1799(class_1802.field_8157);
                                    barrier.method_7977(class_2561.method_43470(""));
                                    for (var i = size; i < container.getSize(); i++) {
                                        container.setSlot(i, barrier);
                                    }

                                    container.setTitle(target.method_5477());
                                    container.open();

                                    var map = Map.of(
                                            "user", class_2561.method_30163(target.method_7334().getName())
                                    );
                                    source.method_9226(() -> module.locale().get("openedTrinkets", map), true);

                                    return 1;
                                }))
                );
    }
}
