package me.alexdevs.solstice.modules.item.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.modules.item.ItemModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import java.util.List;

public class ItemLoreCommand extends ModCommand<ItemModule> {
    public ItemLoreCommand(ItemModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("lore", "itemlore");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("lore", 2))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var item = player.method_6047();

                    if (item.method_7960()) {
                        context.getSource().method_9226(() -> module.locale().get("noItem"), false);
                        return 0;
                    }

                    class_2487 nbtCompound = item.method_7941("display");
                    if (nbtCompound != null) {
                        nbtCompound.method_10551("Lore");
                        if (nbtCompound.method_33133()) {
                            item.method_7983("display");
                        }
                    }

                    context.getSource().method_9226(() -> module.locale().get("loreCleared"), false);

                    return 1;
                })
                .then(class_2170.method_9244("lore", StringArgumentType.greedyString())
                        .executes(context -> {
                            var player = context.getSource().method_9207();
                            var item = player.method_6047();
                            var itemLore = StringArgumentType.getString(context, "lore");

                            if (item.method_7960()) {
                                context.getSource().method_9226(() -> module.locale().get("noItem"), false);
                                return 0;
                            }

                            var playerContext = PlaceholderContext.of(player);
                            var list = new class_2499();
                            for (var line : itemLore.split("\\\\n")) {
                                var text = Format.parse(line, playerContext);
                                list.add(class_2519.method_23256(class_2561.class_2562.method_10867(text)));
                            }

                            var displayNbt = item.method_7911("display");
                            displayNbt.method_10566("Lore", list);

                            context.getSource().method_9226(() -> module.locale().get("loreSet"), false);

                            return 1;
                        })
                );
    }
}
