package me.alexdevs.solstice.modules.jail;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.events.CommandEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.jail.commands.CheckJailCommand;
import me.alexdevs.solstice.modules.jail.commands.JailCommand;
import me.alexdevs.solstice.modules.jail.commands.JailsCommand;
import me.alexdevs.solstice.modules.jail.commands.UnjailCommand;
import me.alexdevs.solstice.modules.jail.data.JailConfig;
import me.alexdevs.solstice.modules.jail.data.JailLocale;
import me.alexdevs.solstice.modules.jail.data.JailPlayerData;
import me.alexdevs.solstice.modules.jail.data.JailServerData;
import me.alexdevs.solstice.modules.spawn.SpawnModule;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.*;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class JailModule extends ModuleBase.Toggleable {
    

    public JailModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerConfig(JailConfig.class, JailConfig::new);
        registerLocale(JailLocale.MODULE);
        registerPlayerData(JailPlayerData.class, JailPlayerData::new);
        registerServerData(JailServerData.class, JailServerData::new);

        commands.add(new JailsCommand(this));
        commands.add(new JailCommand(this));
        commands.add(new UnjailCommand(this));
        commands.add(new CheckJailCommand(this));

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            Solstice.nextTick(() -> {
                var data = getPlayer(handler.method_32311().method_5667());
                if (data.jailed) {
                    sendToJail(handler.method_32311());
                } else if (data.teleportToPreviousLocation) {
                    unjailPlayer(handler.method_32311().method_5667());
                }
            });
        });

        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, player, alive) -> {
            if (isPlayerJailed(player.method_5667())) {
                sendToJail(player);
            }
        });

        ServerLifecycleEvents.SERVER_STARTED.register((server) -> {
            Solstice.scheduler.scheduleAtFixedRate(this::checkJailedPlayers, 0, 1, TimeUnit.SECONDS);
        });

        CommandEvents.ALLOW_COMMAND.register((source, command) -> {
            if (!source.method_43737())
                return true;

            if (isPlayerJailed(source.method_44023().method_5667())) {
                var config = getConfig();
                var cmd = command.split(" ")[0];
                var canRun = config.allowedCommands.contains(cmd);
                if (!canRun) {
                    source.method_9226(() -> locale().get("cannotRunCommands"), false);
                }
                return canRun;
            }

            return true;
        });

        AttackBlockCallback.EVENT.register((player, world, hand, blockPos, direction) -> {
            if (isPlayerJailed(player.method_5667())) {
                player.method_43496(locale().get("cannotBreakBlocks"));
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });

        AttackEntityCallback.EVENT.register((player, world, hand, entity, entityHitResult) -> {
            if (isPlayerJailed(player.method_5667())) {
                player.method_43496(locale().get("cannotAttackEntities"));
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });

        PlayerBlockBreakEvents.BEFORE.register((world, player, blockPos, blockState, blockEntity) -> {
            if (isPlayerJailed(player.method_5667())) {
                player.method_43496(locale().get("cannotBreakBlocks"));
                return false;
            }

            return true;
        });

        UseBlockCallback.EVENT.register((player, world, hand, blockHitResult) -> {
            if (isPlayerJailed(player.method_5667())) {
                player.method_43496(locale().get("cannotUseBlocks"));
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });

        UseEntityCallback.EVENT.register((player, world, hand, entity, entityHitResult) -> {
            if (isPlayerJailed(player.method_5667())) {
                player.method_43496(locale().get("cannotUseEntities"));
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });

        UseItemCallback.EVENT.register((player, world, hand) -> {
            var stack = player.method_5998(hand);
            if (isPlayerJailed(player.method_5667())) {
                player.method_43496(locale().get("cannotUseItems"));
                return class_1271.method_22431(stack);
            }
            return class_1271.method_22430(stack);
        });

        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((signedMessage, player, parameters) -> {
            if (isPlayerJailed(player.method_5667())) {
                var config = getConfig();
                if (config.mute) {
                    player.method_43496(locale().get("cannotSpeak"));
                    return false;
                }
            }
            return true;
        });
    }

    private void checkJailedPlayers() {
        // run on server thread
        Solstice.nextTick(() -> {
            var players = Solstice.server.method_3760().method_14571();
            for (var player : players) {
                var data = getPlayer(player.method_5667());
                if (isPlayerJailed(player.method_5667()) && data.jailTime > 0) {
                    if (data.jailedOn != null && data.jailedOn.getTime() + (data.jailTime * 1000L) < System.currentTimeMillis()) {
                        unjailPlayer(player.method_5667());
                    }
                }
            }

        });
    }

    public JailConfig getConfig() {
        return Solstice.configManager.getData(JailConfig.class);
    }

    public Map<String, ServerLocation> getJails() {
        return Solstice.serverData.getData(JailServerData.class).jails;
    }

    public JailPlayerData getPlayer(UUID uuid) {
        return Solstice.playerData.get(uuid).getData(JailPlayerData.class);
    }

    public boolean isPlayerJailed(UUID uuid) {
        return getPlayer(uuid).jailed;
    }

    public void sendToJail(class_3222 player) {
        Solstice.nextTick(() -> {
            var data = getPlayer(player.method_5667());
            var jails = getJails();
            var jail = jails.get(data.jailName);
            if (jail != null) {
                jail.teleport(player);

                var map = Map.of(
                        "player", player.method_5477(),
                        "jail", class_2561.method_30163(data.jailName),
                        "duration", class_2561.method_30163(TimeSpan.toLongString(data.jailTime)),
                        "reason", class_2561.method_30163(data.jailReason)
                );

                class_2561 text;
                if (data.jailTime > 0) {
                    if (data.jailReason != null) {
                        text = locale().get("playerJailedForWithReason", map);
                    } else {
                        text = locale().get("playerJailedFor", map);
                    }
                } else {
                    text = locale().get("playerJailed", map);
                }
                player.method_7353(text, false);
            }
        });
    }

    public void unjailPlayer(UUID uuid) {
        var data = getPlayer(uuid);
        data.jailed = false;
        data.teleportToPreviousLocation = true;

        var player = Solstice.server.method_3760().method_14602(uuid);
        if (player != null) {
            data.teleportToPreviousLocation = false;

            player.method_43496(locale().get("playerUnjailed"));

            if (data.previousLocation != null) {
                data.previousLocation.teleport(player);
            } else {
                ModuleProvider.SPAWN.getGlobalSpawnPosition().teleport(player);
            }
        }
    }
}
