package me.alexdevs.solstice.modules.jail.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.core.coreModule.data.CoreConfig;
import me.alexdevs.solstice.modules.jail.JailModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CheckJailCommand extends ModCommand<JailModule> {

    public CheckJailCommand(JailModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("checkjail");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require(2))
                .then(class_2170.method_9244("user", StringArgumentType.word())
                        .suggests(LocalGameProfile::suggest)
                        .executes(context -> {
                            var user = LocalGameProfile.getProfile(context, "user");
                            var data = module.getPlayer(user.getId());

                            if (!data.jailed) {
                                context.getSource().method_9226(() -> module.locale().get("notJailed"), false);
                                return 0;
                            }

                            String operator;
                            if (new UUID(0, 0).equals(data.jailedBy)) {
                                operator = "Server";
                            } else {
                                var opProfile = context.getSource().method_9211().method_3793().method_14512(data.jailedBy);
                                if (opProfile.isPresent()) {
                                    operator = opProfile.get().getName();
                                } else {
                                    operator = data.jailedBy != null ? data.jailedBy.toString() : "Unknown";
                                }
                            }

                            String reason;
                            if (data.jailReason != null) {
                                reason = data.jailReason;
                            } else {
                                reason = module.locale().raw("infoJailReasonEmpty");
                            }

                            String duration;
                            if (data.jailTime == 0) {
                                duration = module.locale().raw("infoJailedForEmpty");
                            } else {
                                duration = TimeSpan.toLongString(data.jailTime);
                            }

                            var coreConfig = Solstice.configManager.getData(CoreConfig.class);
                            var df = new SimpleDateFormat(coreConfig.dateTimeFormat);

                            var map = Map.of(
                                    "player", class_2561.method_30163(user.getName()),
                                    "jail", class_2561.method_30163(data.jailName),
                                    "operator", class_2561.method_30163(operator),
                                    "reason", class_2561.method_30163(reason),
                                    "duration", class_2561.method_30163(duration),
                                    "date", class_2561.method_30163(df.format(data.jailedOn))

                            );

                            var text = class_2561.method_43473();
                            text.method_10852(module.locale().get("infoHeader", map));
                            text.method_27693("\n");
                            text.method_10852(module.locale().get("infoJailedAt", map));
                            text.method_27693("\n");
                            text.method_10852(module.locale().get("infoJailedBy", map));
                            text.method_27693("\n");
                            text.method_10852(module.locale().get("infoJailReason", map));
                            text.method_27693("\n");
                            text.method_10852(module.locale().get("infoJailedFor", map));
                            text.method_27693("\n");
                            text.method_10852(module.locale().get("infoJailedOn", map));

                            context.getSource().method_9226(() -> text, false);

                            return 1;
                        })
                );
    }
}
