package me.alexdevs.solstice.modules.jail.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.jail.JailModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

public class UnjailCommand extends ModCommand<JailModule> {
    public UnjailCommand(JailModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("unjail");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("unjail", 2))
                .then(class_2170.method_9244("user", StringArgumentType.word())
                        .suggests(LocalGameProfile::suggest)
                        .executes(context -> {
                            var profile = LocalGameProfile.getProfile(context, "user");

                            var data = module.getPlayer(profile.getId());

                            if (!data.jailed) {
                                context.getSource().method_9226(() -> module.locale().get("notJailed"), false);
                                return 0;
                            }

                            module.unjailPlayer(profile.getId());

                            var map = Map.of(
                                    "player", class_2561.method_30163(profile.getName())
                            );
                            context.getSource().method_9226(() -> module.locale().get("unjailed", map), false);

                            return 1;
                        })
                );
    }
}
