package me.alexdevs.solstice.modules.kick.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.module.Utils;
import me.alexdevs.solstice.modules.kick.KickModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import me.alexdevs.solstice.api.text.Format;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class KickCommand extends ModCommand<KickModule> {
    public KickCommand(KickModule module) {
        super(module);
    }

    private static int execute(CommandContext<class_2168> context, Collection<class_3222> targets, @Nullable String reason) {
        var source = context.getSource();
        for (var target : targets) {
            var playerContext = PlaceholderContext.of(target);
            var reasonText = reason != null ? Format.parse(reason, playerContext) : class_2561.method_43471("multiplayer.disconnect.kicked");
            target.field_13987.method_14367(reasonText);
            source.method_9226(() -> class_2561.method_43469("commands.kick.success", target.method_5476(), reasonText), true);
        }

        return targets.size();
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistry, class_2170.class_5364 environment) {
        Utils.removeCommands(dispatcher, "kick");
        super.register(dispatcher, commandRegistry, environment);
    }

    @Override
    public List<String> getNames() {
        return List.of("kick");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(3))
                .then(method_9244("targets", class_2186.method_9308())
                        .executes(context -> execute(context, class_2186.method_9312(context, "targets"), null))
                        .then(method_9244("reason", StringArgumentType.greedyString())
                                .executes(context -> execute(context, class_2186.method_9312(context, "targets"), StringArgumentType.getString(context, "reason"))))
                );
    }
}
