package me.alexdevs.solstice.modules.kit;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.kit.commands.KitCommand;
import me.alexdevs.solstice.modules.kit.commands.KitsCommand;
import me.alexdevs.solstice.modules.kit.data.*;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import java.util.Date;
import java.util.List;
import java.util.Map;
public class KitModule extends ModuleBase.Toggleable {
    

    public KitModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerConfig(KitConfig.class, KitConfig::new);
        registerLocale(KitLocale.MODULE);
        registerPlayerData(KitPlayerData.class, KitPlayerData::new);
        registerServerData(KitServerData.class, KitServerData::new);

        commands.add(new KitCommand(this));
        commands.add(new KitsCommand(this));

        SolsticeEvents.WELCOME.register((player, server) -> {
            for (var kit : getKits().entrySet()) {
                if (kit.getValue().firstJoin) {
                    claimKit(player, kit.getKey());
                }
            }
        });
    }

    public Map<String, Kit> getKits() {
        return Solstice.serverData.getData(KitServerData.class).kits;
    }

    public boolean createKit(String name, List<class_1799> items) {
        var kits = getKits();
        if (kits.containsKey(name)) {
            return false;
        }
        var kit = new Kit();
        kit.itemStacks = items.stream().map(Utils::serializeItemStack).toList();
        kits.put(name, kit);
        return true;
    }

    /**
     * Claim a kit regardless if the player could claim it.
     * Also flag the player as having it claimed.
     *
     * @param player Player
     * @param name   Kit name
     */
    public void claimKit(class_3222 player, String name) {
        var playerData = Solstice.playerData.get(player).getData(KitPlayerData.class);
        var kit = getKits().get(name);
        var items = kit.getItemStacks();
        var inventory = player.method_31548();
        for (var stack : items) {
            inventory.method_7394(stack);
        }
        playerData.claimedKits.put(name, new Date());
    }

    /**
     * Check if a player has permission to claim a kit.
     *
     * @param player Player
     * @param name   Kit name
     * @return Whether the player has permission to claim the kit.
     */
    public boolean hasKitPermission(class_3222 player, String name) {
        var config = Solstice.configManager.getData(KitConfig.class);
        if (config.requirePermission) {
            return Permissions.check(player, getPermissionNode("kits." + name), 2);
        } else {
            return Permissions.check(player, getPermissionNode("kits." + name), true);
        }
    }

    /**
     * Check if a player could technically claim the kit regardless of permission.
     * This method checks the oneTime flag and cooldown.
     *
     * @param player Player
     * @param name   Kit name
     * @return Whether the player could claim the kit.
     */
    public boolean couldClaimKit(class_3222 player, String name) {
        var kit = getKits().get(name);
        var playerData = Solstice.playerData.get(player).getData(KitPlayerData.class);
        if (kit.oneTime && playerData.claimedKits.containsKey(name)) {
            return false;
        }

        if (kit.cooldownSeconds > 0) {
            if (playerData.claimedKits.containsKey(name)) {
                var startDate = playerData.claimedKits.get(name);
                var nowDate = new Date();

                var delta = (nowDate.getTime() - startDate.getTime()) / 1000;
                return delta >= kit.cooldownSeconds;
            }
        }

        return true;
    }

    public List<String> getPlayerKitNames(class_3222 player) {
        return getKits().keySet().stream().filter(kit -> hasKitPermission(player, kit)).toList();
    }
}
