package me.alexdevs.solstice.modules.miscellaneous;

import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.miscellaneous.commands.*;
import me.alexdevs.solstice.modules.miscellaneous.data.MiscellaneousLocale;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
public class MiscellaneousModule extends ModuleBase.Toggleable {
    public static final float DEFAULT_FLY_SPEED = 0.05F;

    private final Map<UUID, Boolean> commandSleeping = new ConcurrentHashMap<>();

    public MiscellaneousModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerLocale(MiscellaneousLocale.MODULE);

        commands.add(new EffectsCommand(this));
        commands.add(new SleepCommand(this));
        commands.add(new NudgeCommand(this));
        commands.add(new TopCommand(this));
        commands.add(new SpeedCommand(this));
        //commands.add(new KittyCannonCommand(this));
        //commands.add(new RocketCommand(this));

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> commandSleeping.remove(handler.method_32311().method_5667()));
        EntitySleepEvents.STOP_SLEEPING.register((entity, pos) -> commandSleeping.remove(entity.method_5667()));

        EntitySleepEvents.ALLOW_SLEEP_TIME.register((player, pos, vanillaResult) -> {
            if (commandSleeping.getOrDefault(player.method_5667(), false)) {
                return class_1269.field_5812;
            }

            return class_1269.field_5811;
        });

        EntitySleepEvents.ALLOW_RESETTING_TIME.register(player -> {
            if (commandSleeping.getOrDefault(player.method_5667(), false)) {
                return !player.method_37908().method_8530();
            }

            return true;
        });
    }

    public boolean isCommandSleep(class_1309 entity) {
        return commandSleeping.getOrDefault(entity.method_5667(), false);
    }

    /**
     * Make the entity sleep regardless of the bed check.
     * <p>
     * No, this does not euthanize the entity.
     *
     * @param entity The entity to make sleep
     */
    public void putToSleep(class_1309 entity) {
        commandSleeping.put(entity.method_5667(), true);
        entity.method_18403(entity.method_24515());
        if (entity instanceof class_3222 player) {
            player.method_51469().method_8448();
        }
    }
}
