package me.alexdevs.solstice.modules.miscellaneous.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.miscellaneous.MiscellaneousModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.List;
import java.util.Map;

public class EffectsCommand extends ModCommand<MiscellaneousModule> {
    public EffectsCommand(MiscellaneousModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("effects");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("effects.base", 1))
                .executes(context -> execute(context, context.getSource().method_9207()))
                .then(class_2170.method_9244("player", class_2186.method_9305())
                        .requires(require("effects.others", 2))
                        .executes(context -> execute(context, class_2186.method_9315(context, "player")))
                );
    }

    private int execute(CommandContext<class_2168> context, class_3222 target) {
        var effects = target.method_6088();
        if (effects.isEmpty()) {
            context.getSource().method_9226(() -> module.locale().get("noEffects"), false);
            return 0;
        }

        var text = class_2561.method_43473();
        text.method_10852(module.locale().get("effectHeader"));

        for (var entry : effects.entrySet()) {
            text.method_27693("\n");

            var effect = entry.getKey();
            var instance = entry.getValue();

            String duration;
            if (instance.method_48559()) {
                duration = module.locale().raw("infinite");
            } else {
                duration = TimeSpan.toShortString(instance.method_5584() / 20);
            }

            var map = Map.of(
                    "effect", class_2561.method_43471(effect.method_5567()),
                    "amplifier", class_2561.method_30163(String.valueOf(instance.method_5578())),
                    "duration", class_2561.method_30163(duration)
            );
            text.method_10852(module.locale().get("effect", map));
        }

        context.getSource().method_9226(() -> text, false);

        return effects.size();
    }

}
