package me.alexdevs.solstice.modules.miscellaneous.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.command.Flags;
import me.alexdevs.solstice.api.command.flags.Flag;
import me.alexdevs.solstice.api.command.flags.FloatFlag;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.miscellaneous.DummyExplosion;
import me.alexdevs.solstice.modules.miscellaneous.MiscellaneousModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.List;

public class RocketCommand extends ModCommand<MiscellaneousModule> {
    public RocketCommand(MiscellaneousModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("rocket");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("rocket.base", 2))
                .then(class_2170.method_9244("targets", class_2186.method_9306())
                        .executes(context -> execute(context, ""))
                        .then(class_2170.method_9244("flags", StringArgumentType.greedyString())
                                .executes(context -> execute(context, StringArgumentType.getString(context, "flags")))
                        )
                );
    }

    private int execute(CommandContext<class_2168> context, String flags) throws CommandSyntaxException {
        var targets = class_2186.method_9317(context, "targets");

        var explodeFlag = new Flag("explode", List.of('e'));
        var powerFlag = new FloatFlag("power", List.of('p'));
        Flags.parse(flags, explodeFlag, powerFlag);

        var explode = explodeFlag.isUsed();
        var power = 2.0f;
        if (powerFlag.isUsed()) {
            power = powerFlag.getValue();
        }

        var count = 0;
        for (var target : targets) {
            count++;
            if (explode) {
                var world = (class_3218) target.method_37908();
                var pos = target.method_19538();
                DummyExplosion.spawn(world, pos, power * 2);
                world.method_43128(null,
                        pos.field_1352, pos.field_1351, pos.field_1350,
                        class_3417.field_14702, class_3419.field_15250,
                        2, 1);
            }

            target.method_5762(0, power, 0);
            target.field_6037 = true;
        }


        return count;
    }
}
