package me.alexdevs.solstice.modules.miscellaneous.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.miscellaneous.MiscellaneousModule;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import java.util.List;

public class SleepCommand extends ModCommand<MiscellaneousModule> {
    public SleepCommand(MiscellaneousModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("sleep");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("sleep.base", 1))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    module.putToSleep(player);
                    return 1;
                })
                .then(class_2170.method_9244("entities", class_2186.method_9306())
                        .requires(require("sleep.others", 2))
                        .executes(context -> {
                            var targets = class_2186.method_9317(context, "entities");
                            var count = 0;
                            for (var target : targets) {
                                if (target instanceof class_1309 entity) {
                                    module.putToSleep(entity);
                                    count++;
                                }
                            }
                            return count;
                        })
                );
    }
}
