package me.alexdevs.solstice.modules.mute.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.mute.MuteModule;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class MuteCommand extends ModCommand<MuteModule> {
    public MuteCommand(MuteModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("mute");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9244("targets", class_2191.method_9329())
                        .executes(context -> execute(context, 0))
                        .then(method_9244("timespan", TimeSpan.timeSpan())
                                .suggests(TimeSpan::suggest)
                                .executes(context -> execute(context, TimeSpan.getTimeSpan(context, "timespan"))))
                );
    }

    private int execute(CommandContext<class_2168> context, int timespan) throws CommandSyntaxException {
        var targets = class_2191.method_9330(context, "targets");

        var calendar = Calendar.getInstance();
        calendar.add(Calendar.SECOND, timespan);
        var date = calendar.getTime();

        targets.forEach(profile -> {
            var playerData = module.getPlayerData(profile.getId());
            playerData.muted = true;
            if (timespan != 0) {
                playerData.mutedUntil = date;
            }
        });

        Solstice.playerData.saveAll();

        String localeKey;
        if (timespan == 0) {
            if (targets.size() == 1) {
                localeKey = "muted";
            } else {
                localeKey = "mutedMultiple";
            }
        } else {
            if (targets.size() == 1) {
                localeKey = "mutedTimespan";
            } else {
                localeKey = "mutedMultipleTimespan";

            }
        }

        var placeholders = Map.of(
                "count", class_2561.method_30163(String.valueOf(targets.size())),
                "player", class_2561.method_30163(targets.stream().findFirst().get().getName()),
                "timespan", class_2561.method_30163(TimeSpan.toLongString(timespan))
        );

        context.getSource().method_9226(() -> module.locale().get(localeKey, placeholders), true);

        return 1;
    }
}
