package me.alexdevs.solstice.modules.note;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.Components;
import me.alexdevs.solstice.modules.note.commands.NotesCommand;
import me.alexdevs.solstice.modules.note.data.Note;
import me.alexdevs.solstice.modules.note.data.NoteConfig;
import me.alexdevs.solstice.modules.note.data.NoteLocale;
import me.alexdevs.solstice.modules.note.data.NotePlayerData;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.List;
import java.util.Map;
import java.util.UUID;
public class NoteModule extends ModuleBase.Toggleable {
    

    public NoteModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerConfig(NoteConfig.class, NoteConfig::new);
        registerLocale(NoteLocale.MODULE);
        registerPlayerData(NotePlayerData.class, NotePlayerData::new);

        commands.add(new NotesCommand(this));

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            var config = Solstice.configManager.getData(NoteConfig.class);
            if (!config.showLogin)
                return;

            var player = handler.method_32311();
            var notes = getNotes(player.method_5667());

            if (notes.isEmpty())
                return;

            var context = PlaceholderContext.of(player);

            var checkButton = Components.button(
                    locale().raw("checkButton"),
                    locale().raw("hoverCheck"),
                    "/notes " + player.method_7334().getName()
            );
            final var text = locale().get("loginInfo", context, Map.of(
                    "user", class_2561.method_30163(player.method_7334().getName()),
                    "notes", class_2561.method_30163(String.valueOf(notes.size())),
                    "checkButton", checkButton
            ));

            Solstice.nextTick(() ->
                    server.method_3760().method_14571().forEach(pl -> {
                        if (Permissions.check(pl, getPermissionNode("showonlogin"), 2)) {
                            pl.method_43496(text);
                        }
                    }));
        });
    }

    public NotePlayerData getData(UUID uuid) {
        return Solstice.playerData.get(uuid).getData(NotePlayerData.class);
    }

    public List<Note> getNotes(UUID uuid) {
        var data = getData(uuid);
        return data.notes;
    }
}
