package me.alexdevs.solstice.modules.powertool;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.powertool.commands.PowerToolCommand;
import me.alexdevs.solstice.modules.powertool.data.PowerToolLocale;
import me.alexdevs.solstice.modules.powertool.data.PowerToolPlayerData;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.*;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.UUID;
public class PowerToolModule extends ModuleBase.Toggleable {
    

    private CommandDispatcher<class_2168> dispatcher;

    public PowerToolModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerLocale(PowerToolLocale.MODULE);
        registerPlayerData(PowerToolPlayerData.class, PowerToolPlayerData::new);

        commands.add(new PowerToolCommand(this));

        CommandRegistrationCallback.EVENT.register((dispatcher, registry, environment) -> this.dispatcher = dispatcher);

        // USE
        UseItemCallback.EVENT.register((player, world, hand) -> {
            var stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                var data = getData(player.method_5667());
                var itemId = getStackId(stack);
                if (data.powerTools.containsKey(itemId)) {
                    var powertool = data.powerTools.get(itemId);
                    if (powertool.containsKey(Action.USE)) {
                        var source = player.method_5671();
                        execute(source, powertool.get(Action.USE), PlaceholderContext.of(player));

                        return class_1271.method_22428(stack);
                    }
                }
            }
            return class_1271.method_22430(stack);
        });

        // ATTACK_BLOCK
        AttackBlockCallback.EVENT.register((player, world, hand, blockPos, direction) -> {
            var stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                var data = getData(player.method_5667());
                var itemId = getStackId(stack);
                if (data.powerTools.containsKey(itemId)) {
                    var powertool = data.powerTools.get(itemId);
                    if (powertool.containsKey(Action.ATTACK_BLOCK)) {
                        var source = player.method_5671();
                        execute(source, powertool.get(Action.ATTACK_BLOCK), PlaceholderContext.of(player));

                        return class_1269.field_21466;
                    }
                }
            }
            return class_1269.field_5811;
        });

        // ATTACK_ENTITY
        AttackEntityCallback.EVENT.register((player, world, hand, entity, entityHitResult) -> {
            var stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                var data = getData(player.method_5667());
                var itemId = getStackId(stack);
                if (data.powerTools.containsKey(itemId)) {
                    var powertool = data.powerTools.get(itemId);
                    if (powertool.containsKey(Action.ATTACK_ENTITY)) {
                        var source = player.method_5671();
                        execute(source, powertool.get(Action.ATTACK_ENTITY), PlaceholderContext.of(entity));

                        return class_1269.field_21466;
                    }
                }
            }
            return class_1269.field_5811;
        });

        // INTERACT_BLOCK
        UseBlockCallback.EVENT.register((player, world, hand, blockHitResult) -> {
            var stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                var data = getData(player.method_5667());
                var itemId = getStackId(stack);
                if (data.powerTools.containsKey(itemId)) {
                    var powertool = data.powerTools.get(itemId);
                    if (powertool.containsKey(Action.INTERACT_BLOCK)) {
                        var source = player.method_5671();
                        execute(source, powertool.get(Action.INTERACT_BLOCK), PlaceholderContext.of(player));

                        return class_1269.field_21466;
                    }
                }
            }
            return class_1269.field_5811;
        });

        // INTERACT_ENTITY
        UseEntityCallback.EVENT.register((player, world, hand, entity, hit) -> {
            var stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                var data = getData(player.method_5667());
                var itemId = getStackId(stack);
                if (data.powerTools.containsKey(itemId)) {
                    var powertool = data.powerTools.get(itemId);
                    if (powertool.containsKey(Action.INTERACT_ENTITY)) {
                        var source = player.method_5671();
                        execute(source, powertool.get(Action.INTERACT_ENTITY), PlaceholderContext.of(entity));

                        return class_1269.field_21466;
                    }
                }
            }
            return class_1269.field_5811;
        });
    }

    public void execute(class_2168 source, String command, PlaceholderContext context) {
        try {
            dispatcher.execute(resolveCommand(command, context), source);
        } catch (CommandSyntaxException e) {
            source.method_9213(class_2561.method_30163(e.getMessage()));
        }
    }

    private String resolveCommand(String command, PlaceholderContext context) {
        return Placeholders.parseText(class_2561.method_30163(command), context).getString();
    }

    public String getStackId(class_1799 stack) {
        return stack.method_41409().method_40230().get().method_29177().toString();
    }

    public PowerToolPlayerData getData(UUID uuid) {
        return Solstice.playerData.get(uuid).getData(PowerToolPlayerData.class);
    }
}
