package me.alexdevs.solstice.modules.restart.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.events.RestartEvents;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.restart.RestartModule;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class RestartCommand extends ModCommand<RestartModule> {
    public RestartCommand(RestartModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("restart");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(4))
                .then(method_9247("now")
                        .executes(context -> {
                            context.getSource().method_9226(() -> class_2561.method_30163("Restarting server"), true);
                            module.restart();
                            return 1;
                        }))
                .then(method_9247("schedule")
                        .then(method_9244("timespan", StringArgumentType.word())
                                .suggests(TimeSpan::suggest)
                                .executes(context -> schedule(context, TimeSpan.getTimeSpan(context, "timespan"), null))
                                .then(method_9244("message", StringArgumentType.greedyString())
                                        .executes(context -> schedule(context, TimeSpan.getTimeSpan(context, "timespan"), StringArgumentType.getString(context, "message")))))
                        .then(method_9247("next")
                                .executes(this::scheduleNext))
                )
                .then(method_9247("cancel")
                        .executes(this::cancel));
    }

    private int schedule(CommandContext<class_2168> context, int seconds, @Nullable String message) {
        if (module.isRunning()) {
            context.getSource().method_9213(class_2561.method_30163("There is already a running restart."));
            return 0;
        }

        if (message == null) {
            message = module.locale().raw("barLabel");
        }
        module.schedule(seconds, message, RestartEvents.RestartType.MANUAL);

        context.getSource().method_9226(() -> class_2561.method_30163("Manual restart scheduled in " + seconds + " seconds."), true);

        return 1;
    }

    private int scheduleNext(CommandContext<class_2168> context) {
        if (module.isScheduled()) {
            context.getSource().method_9213(class_2561.method_30163("There is already a scheduled restart."));
            return 0;
        }

        var delay = module.scheduleNextRestart();

        if (delay == null) {
            context.getSource().method_9213(class_2561.method_30163("Could not schedule next automatic restart."));
            return 0;
        } else {
            context.getSource().method_9226(() -> class_2561.method_43470("Next automatic restart scheduled in " + delay + " seconds."), true);
        }

        return 1;
    }

    private int cancel(CommandContext<class_2168> context) {
        if (!module.isScheduled()) {
            context.getSource().method_9213(class_2561.method_30163("There is no scheduled restart."));
            return 0;
        }

        module.cancel();
        context.getSource().method_9226(() -> class_2561.method_43470("Restart schedule canceled."), true);
        return 1;
    }
}
