package me.alexdevs.solstice.modules.rtp;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.rtp.commands.RTPCommand;
import me.alexdevs.solstice.modules.rtp.core.Locator;
import me.alexdevs.solstice.modules.rtp.data.RTPConfig;
import me.alexdevs.solstice.modules.rtp.data.RTPLocale;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import java.util.ArrayList;
public class RTPModule extends ModuleBase.Toggleable {
    

    private final ArrayList<Locator> locators = new ArrayList<>();

    public RTPModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerLocale(RTPLocale.MODULE);
        registerConfig(RTPConfig.class, RTPConfig::new);

        commands.add(new RTPCommand(this));

        ServerTickEvents.END_SERVER_TICK.register(server -> locators.removeIf(Locator::tick));
    }

    public RTPConfig getConfig() {
        return Solstice.configManager.getData(RTPConfig.class);
    }

    public Locator createLocator(class_3222 player) {
        var locator = new Locator(player, player.method_51469(), getConfig());
        locators.add(locator);
        return locator;
    }

    public Locator createLocatorWithBiome(class_3222 player, class_5321<class_1959> biome) {
        var locator = new Locator(player, player.method_51469(), getConfig(), biome);
        locators.add(locator);
        return locator;
    }
}
