package me.alexdevs.solstice.modules.rtp.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.rtp.RTPModule;
import me.alexdevs.solstice.modules.rtp.core.Locator;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class RTPCommand extends ModCommand<RTPModule> {
    public RTPCommand(RTPModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("rtp");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .executes(context -> execute(context, false))
                .then(method_9244("biome", class_7733.method_45603(commandRegistry, class_7924.field_41236))
                        .requires(require("biome.base", 2))
                        .suggests((context, builder) -> {
                            if (Permissions.check(context.getSource(), getPermissionNode("exempt.biome"), 2)) {
                                var biomeRegistry = this.commandRegistry.method_41699(class_7924.field_41236);
                                var biomes = biomeRegistry.method_42017().map(r -> r.method_40230().get().method_29177().toString()).toList();
                                return class_2172.method_9265(biomes, builder);
                            }

                            var biomes = getAllowedBiomes(context.getSource(), context.getSource().method_9225());
                            return class_2172.method_9265(biomes, builder);
                        })
                        .executes(context -> execute(context, true))
                );
    }

    private int execute(CommandContext<class_2168> context, boolean withBiome) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var config = module.getConfig();

        if (config.requireWorldPermission) {
            var worldName = player.method_51469().method_27983().method_29177().toString();
            if (!Permissions.check(context.getSource(), getPermissionNode("worlds." + worldName), 2)) {
                context.getSource().method_9226(() -> module.locale().get("noWorldPermission", Map.of("world", class_2561.method_30163(worldName))), false);
                return 0;
            }
        }

        class_5321<class_1959> biome = null;
        if (withBiome) {
            var biomeEntry = class_7733.method_45602(context, "biome", class_7924.field_41236);
            biome = biomeEntry.method_40230().orElse(null);

            if (biomeEntry.method_40230().isPresent()) {
                if (!Permissions.check(context.getSource(), getPermissionNode("exempt.biome"), 2)) {
                    var biomeId = biome.method_29177().toString();
                    var allowedBiomes = getAllowedBiomes(context.getSource(), context.getSource().method_9225());
                    if (!allowedBiomes.contains(biomeId)) {
                        context.getSource().method_9226(() -> module.locale().get("noBiomePermission"), false);
                        return 0;
                    }
                }
            }
        }

        final var server = context.getSource().method_9211();
        final var uuid = player.method_5667();

        Locator locator;
        if (!withBiome) {
            locator = module.createLocator(player);
        } else {
            locator = module.createLocatorWithBiome(player, biome);
        }

        locator.locate(result -> {
            var newPlayer = server.method_3760().method_14602(uuid);
            if (newPlayer == null) {
                Solstice.LOGGER.info("RTP spot found, but player left.");
                return;
            }
            if (result.position().isPresent() && result.type() == Locator.Result.Type.SUCCESS) {
                player.method_43496(module.locale().get("success"));
                result.position().get().teleport(player);
            } else {
                final var text = switch (result.type()) {
                    case TOO_MANY_ATTEMPTS -> module.locale().get("tooManyAttempts");
                    case TIMEOUT -> module.locale().get("timeout");
                    case UNSAFE -> module.locale().get("unsafe");
                    default -> class_2561.method_30163(result.type().toString());
                };
                player.method_43496(text);
            }
        });

        context.getSource().method_9226(() -> module.locale().get("searching"), false);

        return 1;
    }

    private List<String> getAllowedBiomes(class_2168 source, class_3218 world) {
        var groups = getAllowedGroups(source, world);
        var biomes = new ArrayList<String>();
        groups.forEach(group -> biomes.addAll(getBiomesInGroup(world, group)));
        return biomes;
    }

    private List<String> getBiomesInGroup(class_3218 world, String group) {
        var config = module.getConfig();
        var worlds = config.biomeGroups;
        var worldId = world.method_27983().method_29177().toString();
        if (!worlds.containsKey(worldId)) {
            return List.of();
        }

        var groups = worlds.get(worldId);
        if (!groups.containsKey(group)) {
            return List.of();
        }

        return groups.get(group);
    }

    private List<String> getAllowedGroups(class_2168 source, class_3218 world) {
        var worldId = world.method_27983().method_29177().toString();
        if (Permissions.check(source, getPermissionNode("biomes." + worldId + ".base"), 2)) {
            var config = module.getConfig();
            return config.biomeGroups.getOrDefault(worldId, Map.of())
                    .keySet().stream()
                    .filter(name -> Permissions.check(source, getPermissionNode("biomes." + worldId + "." + name), 2))
                    .toList();
        }
        return List.of();
    }
}
