package me.alexdevs.solstice.modules.skull.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.skull.SkullModule;
import net.minecraft.class_2168;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class SkullCommand extends ModCommand<SkullModule> {
    public SkullCommand(SkullModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("skull");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .executes(context -> execute(context, context.getSource().method_9207().method_7334().getName()))
                .then(method_9244("name", StringArgumentType.word())
                        .executes(context -> execute(context, StringArgumentType.getString(context, "name"))));
    }

    private int execute(CommandContext<class_2168> context, String skullName) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var skull = module.createSkull(skullName);

        player.method_31548().method_7394(skull);
        return 1;
    }
}
