package me.alexdevs.solstice.modules.smite.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.Raycast;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.smite.SmiteModule;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class SmiteCommand extends ModCommand<SmiteModule> {
    public static final class_1299<?> entityType = class_1299.field_6112;
    public static final int maxTimes = 1024;
    public static final int maxDistance = 512;

    public SmiteCommand(SmiteModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("smite");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .executes(this::executePos)
                .then(method_9244("target", class_2186.method_9306())
                        .executes(context ->
                                execute(context, 1)
                        )
                        .then(method_9244("times", IntegerArgumentType.integer(0, maxTimes))
                                .executes(context ->
                                        execute(context, IntegerArgumentType.getInteger(context, "times"))
                                )));
    }

    private int executePos(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();

        var result = Raycast.cast(player, maxDistance);
        if (result.method_17783() == class_239.class_240.field_1333) {
            return 0;
        }

        summon(player.method_51469(), result.method_17777().method_10084());

        return 1;
    }

    private int execute(CommandContext<class_2168> context, int times) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var targets = class_2186.method_9317(context, "target");
        var timesToSummon = targets.size() * times;
        if (timesToSummon > maxTimes) {
            times = maxTimes / targets.size();
            if (times == 0)
                times = 1;
        }
        for (var i = 0; i < times; i++) {
            targets.forEach(target ->
                    summon(player.method_51469(), target.method_24515())
            );
        }

        return targets.size();
    }

    private void summon(class_3218 world, class_2338 pos) {
        entityType.method_5888(
                world,
                null,
                world::method_8649,
                pos,
                class_3730.field_16462,
                false,
                false);
    }
}
