package me.alexdevs.solstice.modules.spawn;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.spawn.commands.FirstSpawnCommand;
import me.alexdevs.solstice.modules.spawn.commands.SetFirstSpawnCommand;
import me.alexdevs.solstice.modules.spawn.commands.SetSpawnCommand;
import me.alexdevs.solstice.modules.spawn.commands.SpawnCommand;
import me.alexdevs.solstice.modules.spawn.data.SpawnConfig;
import me.alexdevs.solstice.modules.spawn.data.SpawnLocale;
import me.alexdevs.solstice.modules.spawn.data.SpawnServerData;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class SpawnModule extends ModuleBase.Toggleable {


    public SpawnModule(class_2960 id) {
        super(id);
    }

    @SuppressWarnings("deprecation")
    @Override
    public void init() {
        registerLocale(SpawnLocale.MODULE);
        registerServerData(SpawnServerData.class, SpawnServerData::new);
        registerConfig(SpawnConfig.class, SpawnConfig::new);

        commands.add(new SpawnCommand(this));
        commands.add(new SetSpawnCommand(this));
        commands.add(new FirstSpawnCommand(this));
        commands.add(new SetFirstSpawnCommand(this));

        SolsticeEvents.WELCOME.register((player, server) -> {
            var firstSpawn = getFirstSpawn();
            if (firstSpawn == null) {
                // New player spawn coords is too much of a hassle to mixin. At least the dimension is handled...
                firstSpawn = getGlobalSpawnPosition();
            }
            // java moment
            final var finalSpawn = firstSpawn;

            // Send the next tick, twice, so it does not conflict with the "on-login" spawn setting.
            Solstice.nextTick(() -> Solstice.nextTick(() -> finalSpawn.teleport(player)));
        });

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            var config = getConfig();
            if (config.globalSpawn.onLogin) {
                Solstice.nextTick(() -> {
                    getGlobalSpawnPosition().teleport(handler.method_32311(), false);
                });
            }
        });

        SolsticeEvents.READY.register((instance, server) -> {
            var spawnData = getServerData();
            if (spawnData.spawn != null) {
                var legacy = spawnData.spawn;
                var world = legacy.getWorld(server);
                world.method_8554(new class_2338((int) legacy.getX(), (int) legacy.getY(), (int) legacy.getZ()), legacy.getYaw());
                spawnData.spawn = null;
            }
        });
    }

    @Deprecated
    public ServerLocation getSpawn() {
        var serverData = getServerData();
        var spawnPosition = serverData.spawn;
        if (spawnPosition == null) {
            var server = Solstice.server;
            var spawnPos = server.method_30002().method_43126();
            spawnPosition = new ServerLocation(spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260(), 0, 0, server.method_30002());
        }
        return spawnPosition;
    }

    public class_3218 getGlobalSpawnWorld() {
        var targetWorld = getConfig().globalSpawn.targetSpawnWorld;

        var key = class_5321.method_29179(class_7924.field_41223, class_2960.method_12829(targetWorld));
        return Solstice.server.method_3847(key);
    }

    public ServerLocation getGlobalSpawnPosition() {
        return getWorldSpawn(getGlobalSpawnWorld());
    }

    public ServerLocation getWorldSpawn(class_3218 world) {
        var worldSpawnPosition = world.method_43126().method_46558();
        var worldSpawnYaw = world.method_43127();
        var worldName = world.method_27983().method_29177().toString();

        if (world.method_27983() != class_1937.field_25179) {
            var spawnPoints = getServerData().spawnPoints;
            if (spawnPoints.containsKey(worldName)) {
                return spawnPoints.get(worldName);
            }
        }

        return new ServerLocation(
                worldSpawnPosition.method_10216(), worldSpawnPosition.method_10214(), worldSpawnPosition.method_10215(),
                worldSpawnYaw, 0, world
        );
    }

    public SpawnConfig getConfig() {
        return Solstice.configManager.getData(SpawnConfig.class);
    }

    public SpawnServerData getServerData() {
        return Solstice.serverData.getData(SpawnServerData.class);
    }

    public void sendToSpawn(class_3222 player) {
        sendToSpawn(player, player.method_51469());
    }

    public void sendToSpawn(class_3222 player, class_3218 world) {
        var pos = getWorldSpawn(world);
        pos.teleport(player);
    }

    public @Nullable ServerLocation getFirstSpawn() {
        return Solstice.serverData.getData(SpawnServerData.class).firstSpawn;
    }
}
