package me.alexdevs.solstice.modules.spawn.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.spawn.SpawnModule;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class FirstSpawnCommand extends ModCommand<SpawnModule> {
    public FirstSpawnCommand(SpawnModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("firstspawn");
    }

    private int execute(CommandContext<class_2168> context, @Nullable Collection<class_3222> players) throws CommandSyntaxException {
        if (module.getFirstSpawn() == null) {
            context.getSource().method_9226(() -> module.locale().get("noFirstSpawn"), false);
            return 0;
        }
        if (players == null) {
            var player = context.getSource().method_9207();
            sendToFirstSpawn(context, player);
            return 1;
        } else {
            for (class_3222 player : players) {
                sendToFirstSpawn(context, player);
                context.getSource().method_9226(() -> class_2561.method_43470("Sent ").method_10852(player.method_5476()).method_27693(" to first spawn."), true);
            }
            return players.size();
        }
    }

    private void sendToFirstSpawn(CommandContext<class_2168> context, class_3222 player) {
        var playerContext = PlaceholderContext.of(player);
        context.getSource().method_9226(() -> module.locale().get(
                "teleporting",
                playerContext
        ), false);

        module.getFirstSpawn().teleport(player);
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("firstspawn", true))
                .executes(context -> execute(context, null))
                .then(method_9244("players", class_2186.method_9308())
                        .executes(context -> execute(context, class_2186.method_9312(context, "players"))));
    }


}
