package me.alexdevs.solstice.modules.spawn.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.spawn.SpawnModule;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9247;

public class SetSpawnCommand extends ModCommand<SpawnModule> {
    public SetSpawnCommand(SpawnModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("setspawn");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("set", 3))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var location = new ServerLocation(player);
                    var world = player.method_51469();

                    // world spawn point is ignored on non-overworld levels
                    if(world.method_27983() == class_1937.field_25179) {
                        world.method_8554(
                                location.getBlockPos(),
                                location.getYaw()
                        );
                    } else {
                        module.getServerData().spawnPoints.put(location.getWorld(), location);
                    }

                    context.getSource().method_9226(() -> module.locale().get("worldSpawnSet", Map.of(
                            "world", class_2561.method_30163(world.method_27983().method_29177().toString()),
                            "coordinates", class_2561.method_30163(String.format("%.1f %.1f %.1f", location.getX(), location.getY(), location.getZ()))
                    )), true);

                    return 1;
                });
    }
}
