package me.alexdevs.solstice.modules.spawn.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.spawn.SpawnModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class SpawnCommand extends ModCommand<SpawnModule> {
    public SpawnCommand(SpawnModule module) {
        super(module);
    }

    private int execute(CommandContext<class_2168> context, @Nullable class_3218 world, @Nullable Collection<class_3222> players) throws CommandSyntaxException {
        var config = module.getConfig();
        var skipPermCheck = false;
        if (world == null) {
            if (config.globalSpawn.onSpawnCommand) {
                world = module.getGlobalSpawnWorld();
                skipPermCheck = true;
            } else {
                world = context.getSource().method_9225();
            }
        }

        var worldName = world.method_27983().method_29177().toString();

        if(config.requireWorldPermission && !skipPermCheck) {
            if (!Permissions.check(context.getSource(), getPermissionNode("worlds." + worldName), 2)) {
                context.getSource().method_9226(() -> module.locale().get("noWorldPermission", Map.of("world", class_2561.method_30163(worldName))), false);
                return 0;
            }
        }

        if (players == null) {
            var player = context.getSource().method_9207();
            sendToSpawn(context, player, world);
            return 1;
        } else {
            for (class_3222 player : players) {
                sendToSpawn(context, player, world);
                context.getSource().method_9226(() -> class_2561.method_43470("Sent ").method_10852(player.method_5476()).method_27693(" to " + worldName + " spawn."), true);
            }
            return players.size();
        }
    }

    private void sendToSpawn(CommandContext<class_2168> context, class_3222 player, class_3218 world) {
        var playerContext = PlaceholderContext.of(player);
        context.getSource().method_9226(() -> module.locale().get(
                "teleporting",
                playerContext
        ), false);

        module.sendToSpawn(player, world);
    }

    @Override
    public List<String> getNames() {
        return List.of("spawn");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> execute(context, null, null))
                .then(method_9244("world", class_2181.method_9288())
                        .requires(require("worlds.base", true))
                        .executes(context -> execute(context, class_2181.method_9289(context, "world"), null))
                        .then(method_9244("players", class_2186.method_9308())
                                .requires(require("others", 2))
                                .executes(context -> execute(context, class_2181.method_9289(context, "world"), class_2186.method_9312(context, "players"))))
                );
    }
}
