package me.alexdevs.solstice.modules.staffChat.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.staffChat.StaffChatModule;
import net.minecraft.class_2168;
import net.minecraft.class_2196;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class StaffChatCommand extends ModCommand<StaffChatModule> {
    public StaffChatCommand(StaffChatModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("staffchat", "sc");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(1))
                .executes(context -> {
                    var source = context.getSource();
                    var player = source.method_9207();
                    var enabled = module.toggleStaffChat(player.method_5667());
                    if (enabled) {
                        source.method_9226(() -> module.locale().get("enabled"), false);
                    } else {
                        source.method_9226(() -> module.locale().get("disabled"), false);
                    }
                    return 1;
                })
                .then(method_9244("message", class_2196.method_9340())
                        .executes(context -> {
                            var message = class_2196.method_9339(context, "message");
                            module.sendStaffChatMessage(context.getSource().method_9223(), message);

                            return 1;
                        }));
    }
}
