package me.alexdevs.solstice.modules.styling;

import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.styling.formatters.ChatFormatter;
import me.alexdevs.solstice.modules.styling.formatters.EmoteFormatter;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import net.minecraft.class_7604;
import org.jetbrains.annotations.Nullable;

public interface CustomSentMessage extends class_7604 {

    static class_7604 of(class_7471 message, @Nullable class_3222 sender) {
        if (message.method_46293() && sender == null) {
            return new Profileless(message.method_46291());
        }
        return new Chat(message, sender);
    }

    record Profileless(class_2561 getContent) implements class_7604 {
        @Override
        public class_2561 comp_1081() {
            return getContent;
        }

        @Override
        public void method_45095(class_3222 sender, boolean filterMaskEnabled, class_2556.class_7602 params) {
            sender.field_13987.method_45168(this.getContent, params);
        }
    }

    class Chat implements class_7604 {
        private final class_7471 message;

        @Nullable
        private final class_3222 sender;

        private final class_2561 formattedChatMessage;

        public Chat(class_7471 message, @Nullable class_3222 sender) {
            this.message = message;
            this.sender = sender;

            // Instead of building the message for every single player in the server, we create a cache of it.
            // The chance that this is used as a chat message is much, much higher than the other cases (me, team msg).
            formattedChatMessage = ChatFormatter.getFormattedMessage(message, sender);
        }

        @Override
        public class_2561 comp_1081() {
            return this.message.method_46291();
        }

        @Override
        public void method_45095(class_3222 receiver, boolean filterMaskEnabled, class_2556.class_7602 params) {
            var ignoreModule = ModuleProvider.IGNORE;
            if (ignoreModule.isEnabled() && ignoreModule.isIgnoring(receiver, sender)) {
                return;
            }

            class_7471 signedMessage = this.message.method_45099(filterMaskEnabled);
            if (signedMessage.method_45100()) {
                return;
            }

            switch (params.comp_919().comp_792().comp_788()) {
                case "chat.type.text":
                    receiver.method_43496(this.formattedChatMessage);
                    break;
                case "chat.type.emote":
                    EmoteFormatter.sendEmoteMessage(receiver, message, params, sender);
                    break;
                default:
                    receiver.field_13987.method_45168(this.message.method_46291(), params);
                    break;
            }

        }
    }
}
