package me.alexdevs.solstice.modules.sudo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.sudo.SudoModule;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class DoAsCommand extends ModCommand<SudoModule> {
    public DoAsCommand(SudoModule module) {
        super(module);
    }

    public static void execute(CommandDispatcher<class_2168> dispatcher, String command, class_2168 source, class_2168 output) {
        try {
            dispatcher.execute(command, source);
        } catch (Exception e) {
            output.method_9213(class_2561.method_30163(String.format("[%s] %s", source.method_9214(), e.getMessage())));
        }
    }

    public static class_2168 buildPlayerSource(class_2165 commandOutput, MinecraftServer server, class_3222 player) {
        var opList = server.method_3760().method_14603();
        var operator = opList.method_14640(player.method_7334());
        int opLevel = 0;
        if (operator != null) {
            opLevel = operator.method_14623();
        }
        return new class_2168(
                commandOutput,
                player.method_19538(),
                player.method_5802(),
                player.method_51469(),
                opLevel,
                player.method_5820(),
                player.method_5476(),
                server,
                player
        );
    }

    @Override
    public List<String> getNames() {
        return List.of("doas");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("doas", 4))
                .then(method_9244("player", class_2186.method_9308())
                        .then(method_9244("command", StringArgumentType.greedyString())
                                .executes(context -> {
                                    var players = class_2186.method_9312(context, "player");
                                    var profileArgRange = context.getNodes().get(1).getRange();
                                    var stringProfiles = context.getInput().substring(
                                            profileArgRange.getStart(),
                                            profileArgRange.getEnd()
                                    );

                                    var command = StringArgumentType.getString(context, "command");

                                    context.getSource().method_9226(() -> class_2561.method_43470(String.format("Executing '%s' as %s", command, stringProfiles)), true);

                                    class_2165 commandOutput;
                                    if (context.getSource().method_43737()) {
                                        commandOutput = context.getSource().method_44023();
                                    } else {
                                        commandOutput = context.getSource().method_9211();
                                    }

                                    var server = context.getSource().method_9211();
                                    for (var player : players) {
                                        var source = buildPlayerSource(commandOutput, server, player);
                                        execute(dispatcher, command, source, context.getSource());
                                    }

                                    return 1;
                                })
                        )
                );
    }
}
