package me.alexdevs.solstice.modules.sudo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.sudo.SudoModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_241;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.server.MinecraftServer;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class SudoCommand extends ModCommand<SudoModule> {
    public SudoCommand(SudoModule module) {
        super(module);
    }

    public static void execute(CommandDispatcher<class_2168> dispatcher, String command, class_2168 source, class_2168 output) {
        try {
            dispatcher.execute(command, source);
        } catch (Exception e) {
            output.method_9213(class_2561.method_30163(String.format("[%s] %s", source.method_9214(), e.getMessage())));
        }
    }

    @Override
    public List<String> getNames() {
        return List.of("sudo");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .then(method_9244("command", StringArgumentType.greedyString())
                        .executes(context -> {
                            if (!Permissions.check(context.getSource(), getPermissionNode("sudo"), 4)) {
                                context.getSource().method_9213(class_2561.method_43470(String.format("%s is not in the sudoers file. This incident will be reported.", context.getSource().method_9214()))
                                        .method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://xkcd.com/838/"))));
                                return 1;
                            }
                            var command = StringArgumentType.getString(context, "command");

                            context.getSource().method_9226(() -> class_2561.method_43470(String.format("Executing '%s' as Server", command)), true);

                            class_2165 commandOutput;
                            if (context.getSource().method_43737()) {
                                commandOutput = context.getSource().method_44023();
                            } else {
                                commandOutput = context.getSource().method_9211();
                            }

                            var server = context.getSource().method_9211();
                            var source = buildServerSource(commandOutput, server);
                            execute(dispatcher, command, source, context.getSource());

                            return 1;
                        })
                );
    }

    public class_2168 buildServerSource(class_2165 commandOutput, MinecraftServer server) {
        return new class_2168(
                commandOutput,
                server.method_30002().method_43126().method_46558(),
                class_241.field_1340,
                server.method_30002(),
                4,
                "Server",
                class_2561.method_30163("Server"),
                server,
                null
        );
    }
}
