package me.alexdevs.solstice.modules.teleportOffline.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.core.coreModule.data.CorePlayerData;
import me.alexdevs.solstice.modules.teleportOffline.TeleportOfflineModule;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TeleportOfflineCommand extends ModCommand<TeleportOfflineModule> {
    public TeleportOfflineCommand(TeleportOfflineModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("tpoffline", "tpoff");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9244("player", StringArgumentType.word())
                        .suggests(LocalGameProfile::suggest)
                        .executes(context -> {
                            var source = context.getSource();
                            var player = source.method_9207();

                            var gameProfile = LocalGameProfile.getProfile(context, "player");

                            var targetData = Solstice.playerData.get(gameProfile).getData(CorePlayerData.class);
                            if (targetData == null || targetData.logoffPosition == null) {
                                source.method_9213(class_2561.method_30163("Could not find location of offline player"));
                                return 0;
                            }

                            source.method_9226(() -> class_2561.method_43469("commands.teleport.success.entity.single", player.method_5476(), class_2561.method_30163(gameProfile.getName())), true);

                            targetData.logoffPosition.teleport(player, true);
                            return 1;
                        }));
    }
}
