package me.alexdevs.solstice.modules.utilities.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.utilities.UtilitiesModule;
import me.alexdevs.solstice.modules.utilities.virtualScreenHandlers.VirtualCartographyTableScreenHandler;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3468;
import net.minecraft.class_3914;
import net.minecraft.class_747;
import java.util.List;

import static net.minecraft.class_2170.method_9247;

public class CartographyCommand extends ModCommand<UtilitiesModule> {
    public CartographyCommand(UtilitiesModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("cartography");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("cartography", 2))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var screen = new class_747(
                            (syncId, inventory, p) ->
                                    new VirtualCartographyTableScreenHandler(syncId, inventory, class_3914.method_17392(player.method_37908(), player.method_24515())),
                            class_2561.method_43471("container.cartography_table"));
                    player.method_17355(screen);
                    player.method_7281(class_3468.field_19252);

                    return 1;
                });
    }
}
