package me.alexdevs.solstice.modules.warp;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.warp.commands.DeleteWarpCommand;
import me.alexdevs.solstice.modules.warp.commands.SetWarpCommand;
import me.alexdevs.solstice.modules.warp.commands.WarpCommand;
import me.alexdevs.solstice.modules.warp.commands.WarpsCommand;
import me.alexdevs.solstice.modules.warp.data.WarpLocale;
import me.alexdevs.solstice.modules.warp.data.WarpServerData;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class WarpModule extends ModuleBase.Toggleable {
    

    public WarpModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerLocale(WarpLocale.MODULE);
        registerServerData(WarpServerData.class, WarpServerData::new);

        commands.add(new WarpCommand(this));
        commands.add(new WarpsCommand(this));
        commands.add(new SetWarpCommand(this));
        commands.add(new DeleteWarpCommand(this));
    }

    public boolean canUseWarp(class_3222 player, String warpName) {
        return Permissions.check(player, getPermissionNode("warps." + warpName), true);
    }
}
