package me.alexdevs.solstice.modules.warp.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.warp.WarpModule;
import me.alexdevs.solstice.modules.warp.data.WarpServerData;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class DeleteWarpCommand extends ModCommand<WarpModule> {
    public DeleteWarpCommand(WarpModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("delwarp");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("set", 2))
                .then(method_9244("name", StringArgumentType.word())
                        .suggests((context, builder) -> {
                            var serverData = Solstice.serverData.getData(WarpServerData.class);
                            return class_2172.method_9264(serverData.warps.keySet().stream().sorted(), builder);
                        })
                        .executes(context -> execute(context, StringArgumentType.getString(context, "name"))));
    }

    private int execute(CommandContext<class_2168> context, String name) {
        var serverData = Solstice.serverData.getData(WarpServerData.class);
        var warps = serverData.warps;

        if (!warps.containsKey(name)) {
            context.getSource().method_9226(() -> module.locale().get(
                    "warpNotFound",
                    Map.of(
                            "warp", class_2561.method_30163(name)
                    )
            ), true);
            return 0;
        }

        warps.remove(name);

        context.getSource().method_9226(() -> module.locale().get(
                "deleted",
                Map.of(
                        "warp", class_2561.method_30163(name)
                )
        ), true);

        return 1;
    }
}
